package w83a.w83aDAO;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.lang.StringUtils;

import w83a.util.jdbc.W83aDataBase;
import w83a.w83aBeans.W83aResultadosBean;
import w83a.w83aDAO.w83aConstantesBD.W83aActasBD;
import w83a.w83aDAO.w83aConstantesBD.W83aResultadosBD;
import w83a.w83aUtilidadesComunes.W83aClsConstantes;
import w83a.w83aUtilidadesComunes.W83aDateUtil;
import java.text.ParseException;

// TODO: Auto-generated Javadoc
/**
 * The Class W83aResultadosDAO.
 */
public class W83aResultadosDAO implements W83aIResultadosDAO {
	
	public String calcularFechaHistorico(w83a.w83aBeans.W83aResultadosBean param) throws Exception{
		StringBuffer strSql = new StringBuffer(W83aClsConstantes.CUARENTA);
		List params = new ArrayList();
		strSql.append("SELECT "); 
		strSql.append(W83aResultadosBD.anocierre).append(", ");
		strSql.append(W83aResultadosBD.mescierre);
		strSql.append(" FROM ").append(W83aResultadosBD.tablacierre);
		strSql.append(" WHERE ");
		if(W83aClsConstantes.CONSTANTE_ALAVA.equals(param.getTerritorio())){
			strSql.append(W83aResultadosBD.cierrealava).append("='S'");
		}
		if(W83aClsConstantes.CONSTANTE_BIZKAIA.equals(param.getTerritorio())){
				strSql.append(W83aResultadosBD.cierrebizkaia).append("='S'");
				
		}
		if(W83aClsConstantes.CONSTANTE_GIPUZKOA.equals(param.getTerritorio())){
			strSql.append(W83aResultadosBD.cierregipuzkoa).append("='S'");
		}
		strSql.append(" ORDER BY ");
		strSql.append(W83aResultadosBD.anocierre).append(" DESC, ");
		strSql.append(W83aResultadosBD.mescierre).append(" DESC");
		
		HashMap mapaQuerie = new HashMap();
		mapaQuerie.put("idioma", param.getIdioma());
		mapaQuerie.put("querie", "cierre");
		List lista = W83aDataBase.executeQuery(strSql.toString(),params,W83aResultadosBean.class,param.getUsuarioBean(), mapaQuerie);
	
		String DATE_FORMAT;
		if (W83aClsConstantes.CONSTANTE_CASTELLANO.equals(param.getIdioma())){
			DATE_FORMAT = "dd/MM/yyyy";
		}
		else{
			DATE_FORMAT = "yyyy/MM/dd";
		}
		java.text.SimpleDateFormat sdf = new java.text.SimpleDateFormat(DATE_FORMAT);
		Calendar c1 = Calendar.getInstance(); 
		c1.set(Integer.parseInt(((W83aResultadosBean)lista.get(0)).getAnocierre()), Integer.parseInt(((W83aResultadosBean)lista.get(0)).getMescierre())-1 , 1);
		int dias=c1.getActualMaximum(Calendar.DAY_OF_MONTH);
		c1.set(Integer.parseInt(((W83aResultadosBean)lista.get(0)).getAnocierre()), Integer.parseInt(((W83aResultadosBean)lista.get(0)).getMescierre())-1 , dias);
		
		return sdf.format(c1.getTime());
	}
	
	public java.util.List w83acabdelegsindconv(w83a.w83aBeans.W83aResultadosBean param) throws Exception{
		StringBuffer strSql = new StringBuffer();//NOPMD
		List params = new ArrayList();
		strSql.append("SELECT "); 
		strSql.append(W83aResultadosBD.totalelectores).append(", ");
		strSql.append(W83aResultadosBD.totalvotos).append(", ");
		strSql.append(W83aResultadosBD.numcentros);
		strSql.append(" FROM TABLE (w83b.");
	    strSql.append(W83aResultadosBD.w83acabdelegsindconv);
	    strSql.append("(?,?,?,?,?,?,?))");
	    
	    params.add(W83aDateUtil.getInstance().getLocaleStringFromDate(W83aDateUtil.getInstance().stringToDateIdioma(param.getFechaEleccionDesde(),param.getIdioma()), W83aClsConstantes.CONSTANTE_CASTELLANO));
	    params.add(W83aDateUtil.getInstance().getLocaleStringFromDate(W83aDateUtil.getInstance().stringToDateIdioma(param.getFechaEleccionHasta(),param.getIdioma()), W83aClsConstantes.CONSTANTE_CASTELLANO));
	    params.add(W83aDateUtil.getInstance().getLocaleStringFromDate(W83aDateUtil.getInstance().stringToDateIdioma(param.getFechaRegistroDefinitivo(),param.getIdioma()), W83aClsConstantes.CONSTANTE_CASTELLANO));
	    params.add(param.getTerritorio());
	    params.add(param.getNumTrabajadores());
	    if(StringUtils.isNotEmpty(param.getFechaHistorico())){
	    	params.add(W83aDateUtil.getInstance().getLocaleStringFromDate(W83aDateUtil.getInstance().stringToDateIdioma(param.getFeHist(),param.getIdioma()), W83aClsConstantes.CONSTANTE_CASTELLANO));
	    	params.add(W83aDateUtil.getInstance().getLocaleStringFromDate(W83aDateUtil.getInstance().stringToDateIdioma(param.getFechaHistorico(),param.getIdioma()), W83aClsConstantes.CONSTANTE_CASTELLANO));
	    }
	    else{
	    	params.add("vacio");
	    	params.add("vacio");
	    }	 
		
		
		HashMap mapaQuerie = new HashMap();
		mapaQuerie.put("idioma", param.getIdioma());
		mapaQuerie.put("querie", "cabdelegsindconv");
	    List l=W83aDataBase.executeQuery(strSql.toString(),params,W83aResultadosBean.class,param.getUsuarioBean(), mapaQuerie);	
		return l;//NOPMD
	}
	
	public java.util.Map buscarCuadroResultados(w83a.w83aBeans.W83aResultadosBean param) throws Exception{
		StringBuffer strSql = new StringBuffer(W83aClsConstantes.CUARENTA);
		List params = new ArrayList();
		strSql.append("SELECT ");
		strSql.append(W83aResultadosBD.nacta).append(", ");
		strSql.append(W83aResultadosBD.anoacta).append(", ");
		strSql.append(W83aResultadosBD.ver).append(", ");
		strSql.append(W83aResultadosBD.codsindicato).append(", ");
		strSql.append(W83aResultadosBD.siglas).append(", ");
		strSql.append(W83aResultadosBD.sinddesc).append(", ");
		strSql.append(W83aResultadosBD.sinddese).append(", ");
		strSql.append(W83aResultadosBD.tipoconvenio).append(", ");
		strSql.append(W83aResultadosBD.numdelegados).append(", ");
		strSql.append(W83aResultadosBD.totalelectores).append(", ");
		strSql.append(W83aResultadosBD.cif).append(", ");
		strSql.append(W83aResultadosBD.territ).append(", TO_CHAR(");
		strSql.append(W83aResultadosBD.fechaActu).append(",'dd/MM/yyyy') ").append(W83aResultadosBD.fechaActu);
		strSql.append(" FROM TABLE (w83b.");
	    strSql.append(W83aResultadosBD.vistaCuadroResultados);
	    strSql.append("(?,?,?,?,?,?,?))");
	    if(StringUtils.isEmpty(param.getFechaHistorico())){
		    strSql.append(" where ver = (SELECT MAX (");
		    strSql.append(W83aActasBD.versionActa);
		    strSql.append(") FROM ");
		    strSql.append(W83aActasBD.actasTable);
		    strSql.append(" act WHERE ");
		    strSql.append(W83aResultadosBD.nacta);
		    strSql.append(" = act.");
		    strSql.append(W83aActasBD.numActa);
		    strSql.append(" AND ");
		    strSql.append(W83aResultadosBD.anoacta);
		    strSql.append(" = act.");
		    strSql.append(W83aActasBD.anyoActa);
		    strSql.append(" AND ");
		    strSql.append(W83aResultadosBD.territ);
		    strSql.append(" = act.");
		    strSql.append(W83aActasBD.codTerritActa);
		    strSql.append(" AND act.");
		    strSql.append(W83aActasBD.validada);
		    strSql.append(" = 1)");
	    }else{    	
	    	strSql.append(" dc, ");
			strSql.append(" (SELECT MAX (").append(W83aResultadosBD.VERSION_016).append(" ) AS maxver, ");
			strSql.append(W83aResultadosBD.N_ACTA_016).append(",").append(W83aResultadosBD.ANO_ACTA_016).append(",");
			strSql.append(W83aResultadosBD.C_TERRIT_016).append(" FROM ").append(W83aResultadosBD.tabla16);
			strSql.append(" WHERE 1=1");
			if(StringUtils.isNotEmpty(param.getTerritorio())&&param.getTerritorio()!=null&&!"todos".equals(param.getTerritorio())){
				strSql.append(" AND ");
				strSql.append(W83aResultadosBD.C_TERRIT_016).append("=").append("? ");
			}
			//QUITADO POR JAVI
			//SE SUPONE EL SGTE CASO:
			//UN ACTA V0 CON FECHA DE ELECCIN DE 30/5/2012
			//SE CREA UNA INICIDENCIA Y SE CAMBIA EL 27/06/2013 (FACTU) LA FECHA DE ELECCIN A 01/06/2013
			//SACAMOS ESTE INFORME CON FECHA HISTORICO 27/05/2013 PARA QUE LA INCIDENCIA CUENTE, 
			//Y EN FECHA DE RESULTADO PONEMOS 31/05/2013
			//AL SER LA FECHA DE ELECCIN ENTRE 01/06/2009 - 31/05/2013
			//Y LA VERSIN QUE CUENTA PARA ESA FECHA HISTRICO ES LA VERSIN DE LA INCIDENCIA
			//ESTE ACTA NO DEBERA SALIR. 
			//AL COGER LA QUERY QUE COGE LA MAXVERSION EL ACTA QUE COINCIDE CON  FECHA DE ELECCIN ENTRE 01/06/2009 - 31/05/2013
			//CONSIDERA SOLO LA VERSIN 0
			//HE KITADO ESAS LNEAS XQ ESE FILTRO LO DEBERA HACER LA OTRA QUERY
			/*strSql.append(" AND ");
			strSql.append(W83aResultadosBD.FREGDEF_016).append("<=").append("TO_DATE(?,'dd/MM/yyyy') ");
			strSql.append(" AND ");
			strSql.append(W83aResultadosBD.F_ELECC_016).append(">=").append("TO_DATE(?,'dd/MM/yyyy') ");
			strSql.append(" AND ");
			strSql.append(W83aResultadosBD.F_ELECC_016).append("<=").append("TO_DATE(?,'dd/MM/yyyy') ");*/
			
			strSql.append(" AND (");
			strSql.append(W83aResultadosBD.F_BAJA_016).append(" IS NULL ");
			
			if(StringUtils.isNotEmpty(param.getFechaHistorico()))
				{
					
					strSql.append(" OR ");
					strSql.append(W83aResultadosBD.F_BAJA_016).append(">").append("TO_DATE(?,'dd/MM/yyyy') ");
					
				}
			strSql.append(" )");

			
			strSql.append(" AND (").append(W83aResultadosBD.factu_016).append("<=TO_DATE('").append(W83aDateUtil.getInstance().getLocaleStringFromDate(W83aDateUtil.getInstance().stringToDateIdioma(param.getFeHist(),param.getIdioma()), W83aClsConstantes.CONSTANTE_CASTELLANO)).append(" 23:59:59','dd/MM/yyyy hh24:mi:ss')");
			strSql.append(" OR ").append(W83aResultadosBD.factu_016).append(" IS NULL )");
			strSql.append(" AND ").append(W83aResultadosBD.validada_016).append("=1");
			strSql.append(" GROUP BY ").append(W83aResultadosBD.N_ACTA_016).append(",");
			strSql.append(W83aResultadosBD.ANO_ACTA_016).append(",").append(W83aResultadosBD.C_TERRIT_016).append(" ) maxresults ");
			
			strSql.append(" where DC.").append(W83aResultadosBD.nacta).append("=").append("maxresults.").append(W83aResultadosBD.N_ACTA_016);
			strSql.append(" AND ");
			strSql.append("DC.").append(W83aResultadosBD.anoacta).append("=").append("maxresults.").append(W83aResultadosBD.ANO_ACTA_016);
			strSql.append(" AND ");
			strSql.append("DC.").append(W83aResultadosBD.territ).append("=").append("maxresults.").append(W83aResultadosBD.C_TERRIT_016);
			strSql.append(" AND ");
			strSql.append("DC.").append(W83aResultadosBD.ver).append("=").append("maxresults.maxver");
	    }
	    
	    params.add(W83aDateUtil.getInstance().getLocaleStringFromDate(W83aDateUtil.getInstance().stringToDateIdioma(param.getFechaEleccionDesde(),param.getIdioma()), W83aClsConstantes.CONSTANTE_CASTELLANO));
	    params.add(W83aDateUtil.getInstance().getLocaleStringFromDate(W83aDateUtil.getInstance().stringToDateIdioma(param.getFechaEleccionHasta(),param.getIdioma()), W83aClsConstantes.CONSTANTE_CASTELLANO));
	    params.add(W83aDateUtil.getInstance().getLocaleStringFromDate(W83aDateUtil.getInstance().stringToDateIdioma(param.getFechaRegistroDefinitivo(),param.getIdioma()), W83aClsConstantes.CONSTANTE_CASTELLANO));
	    params.add(param.getTerritorio());
	    params.add(param.getNumTrabajadores());
	    
	 
	    if(StringUtils.isNotEmpty(param.getFechaHistorico())){
	    	params.add(W83aDateUtil.getInstance().getLocaleStringFromDate(W83aDateUtil.getInstance().stringToDateIdioma(param.getFeHist(),param.getIdioma()), W83aClsConstantes.CONSTANTE_CASTELLANO));
	    	params.add(W83aDateUtil.getInstance().getLocaleStringFromDate(W83aDateUtil.getInstance().stringToDateIdioma(param.getFechaHistorico(),param.getIdioma()), W83aClsConstantes.CONSTANTE_CASTELLANO));
	    }
	    else{
	    	params.add("nohay");
	    	params.add("nohay");
	    }
	    
	    if(StringUtils.isNotEmpty(param.getFechaHistorico())){
			if(StringUtils.isNotEmpty(param.getTerritorio())&&param.getTerritorio()!=null&&!"todos".equals(param.getTerritorio())){
				params.add(param.getTerritorio());
			}
			/*params.add(W83aDateUtil.getInstance().getLocaleStringFromDate(W83aDateUtil.getInstance().stringToDateIdioma(param.getFechaRegistroDefinitivo(),param.getIdioma()), W83aClsConstantes.CONSTANTE_CASTELLANO));
			params.add(W83aDateUtil.getInstance().getLocaleStringFromDate(W83aDateUtil.getInstance().stringToDateIdioma(param.getFechaEleccionDesde(),param.getIdioma()), W83aClsConstantes.CONSTANTE_CASTELLANO));
			params.add(W83aDateUtil.getInstance().getLocaleStringFromDate(W83aDateUtil.getInstance().stringToDateIdioma(param.getFechaEleccionHasta(),param.getIdioma()), W83aClsConstantes.CONSTANTE_CASTELLANO));*/
			if(StringUtils.isNotEmpty(param.getFechaHistorico()))
			{
				params.add(W83aDateUtil.getInstance().getLocaleStringFromDate(W83aDateUtil.getInstance().stringToDateIdioma(param.getFechaHistorico(),param.getIdioma()), W83aClsConstantes.CONSTANTE_CASTELLANO));
			}
		}
	    
		
		HashMap mapaQuerie = new HashMap();
		mapaQuerie.put("idioma", param.getIdioma());
		mapaQuerie.put("querie", "cuadroResultados");
	  
		List lista = W83aDataBase.executeQuery(strSql.toString(),params,W83aResultadosBean.class,param.getUsuarioBean(), mapaQuerie);
		
		String nacta="";
		String territ="";
		String anoacta="";
		int maxversion=0;
		Map mapa=new HashMap();
		Map sindicatos=new HashMap();
		Map convenios=new HashMap();
		int nd=0;
		//Date fecha=new Date();
		/*if(StringUtils.isNotEmpty(param.getFechaHistorico())){
			fecha=W83aDateUtil.getInstance().stringToDateIdioma(param.getFechaHistorico(), "es");
		}*/
		int delegadosmenorigual49=0;
		int delegadosmayor49=0;
		if (!"todos".equals(param.getTerritorio())){
			for (int i=0;i<lista.size();i++){
				W83aResultadosBean res = (W83aResultadosBean)lista.get(i);
				//Se cogen slo las actas de mayor versin
				if (i==0||
						((nacta.equals(res.getNacta())
								&&territ.equals(res.getTerritorio())
								&&anoacta.equals(res.getAnoacta())
								&&maxversion==Integer.parseInt(res.getVer()))
								&&StringUtils.isEmpty(param.getFechaHistorico())
								
								||
								(nacta.equals(res.getNacta())
										&&territ.equals(res.getTerritorio())
										&&anoacta.equals(res.getAnoacta())
										&&maxversion==Integer.parseInt(res.getVer()))
										&&StringUtils.isNotEmpty(param.getFechaHistorico())
										//&&(W83aDateUtil.getInstance().stringToDateIdioma(res.getFechaActualizacion(), "es").compareTo(fecha)<=0)
						)
								
								
								
					||(!nacta.equals(res.getNacta())
							||!territ.equals(res.getTerritorio())
							||!anoacta.equals(res.getAnoacta()))
					){
					//habria que mirar lo de la fecha actualizacion
					if (res.getCodsindicato()!=null&&res.getTipoconvenio()!=null){
						if (Integer.parseInt(res.getTotalelectores())>49){
							delegadosmayor49+=Integer.parseInt(res.getNumdelegados());
						}
						else{
							delegadosmenorigual49+=Integer.parseInt(res.getNumdelegados());
						}
						if (sindicatos.get(res.getSiglas()+"|"+res.getSinddesc()+"|"+res.getSinddese())==null){
							convenios=new HashMap();//NOPMD
							convenios.put(res.getTipoconvenio(),res.getNumdelegados());
							sindicatos.put(res.getSiglas()+"|"+res.getSinddesc()+"|"+res.getSinddese(), convenios);
						}
						else{
							Map c=(Map)sindicatos.get(res.getSiglas()+"|"+res.getSinddesc()+"|"+res.getSinddese());
							convenios=new HashMap();//NOPMD
							convenios=c=(Map)sindicatos.get(res.getSiglas()+"|"+res.getSinddesc()+"|"+res.getSinddese());
							if (c.get(res.getTipoconvenio())!=null){
								if (res.getTipoconvenio()!=null){
									nd=Integer.parseInt((String)c.get(res.getTipoconvenio()))+Integer.parseInt(res.getNumdelegados());	
									convenios.put(res.getTipoconvenio(),String.valueOf(nd));
									sindicatos.put(res.getSiglas()+"|"+res.getSinddesc()+"|"+res.getSinddese(), convenios);
								}
							}
							else{
								convenios.put(res.getTipoconvenio(),res.getNumdelegados());
								sindicatos.put(res.getSiglas()+"|"+res.getSinddesc()+"|"+res.getSinddese(), convenios);
							}
						}
					}
				}
				//Hay que coger las actas de mayor versin
				//En la sql estn ordenadas por versin descendente
				if (!nacta.equals(res.getNacta())||!territ.equals(res.getTerritorio())||!anoacta.equals(res.getAnoacta())){
					maxversion=Integer.parseInt(res.getVer());
				}
				nacta=res.getNacta();
				territ=res.getTerritorio();
				anoacta=res.getAnoacta();
		    }
		}
		else{
			Map territorios=new HashMap();
			for (int i=0;i<lista.size();i++){
				W83aResultadosBean res = (W83aResultadosBean)lista.get(i);
				if (i==0||
								
						((nacta.equals(res.getNacta())
								&&territ.equals(res.getTerritorio())
								&&anoacta.equals(res.getAnoacta())
								&&maxversion==Integer.parseInt(res.getVer()))
								&&StringUtils.isEmpty(param.getFechaHistorico())
								
								||
								(nacta.equals(res.getNacta())
										&&territ.equals(res.getTerritorio())
										&&anoacta.equals(res.getAnoacta())
										&&maxversion==Integer.parseInt(res.getVer()))
										&&StringUtils.isNotEmpty(param.getFechaHistorico())
										//&&(W83aDateUtil.getInstance().stringToDateIdioma(res.getFechaActualizacion(), "es").compareTo(fecha)<=0)
						)		
								
						//habria que mirar lo de la fecha actualizacion
						||(!nacta.equals(res.getNacta())||!territ.equals(res.getTerritorio())||!anoacta.equals(res.getAnoacta()))){
					if (res.getCodsindicato()!=null&&res.getTipoconvenio()!=null){
						if (Integer.parseInt(res.getTotalelectores())>49){
							delegadosmayor49+=Integer.parseInt(res.getNumdelegados());
						}
						else{
							delegadosmenorigual49+=Integer.parseInt(res.getNumdelegados());
						}
						if (sindicatos.get(res.getSiglas()+"|"+res.getSinddesc()+"|"+res.getSinddese())==null){
							convenios=new HashMap();//NOPMD
							territorios=new HashMap();//NOPMD
							territorios.put(res.getTerritorio(), res.getNumdelegados());
							convenios.put(res.getTipoconvenio(),territorios);
							sindicatos.put(res.getSiglas()+"|"+res.getSinddesc()+"|"+res.getSinddese(), convenios);
						}
						else{
							Map c=(Map)sindicatos.get(res.getSiglas()+"|"+res.getSinddesc()+"|"+res.getSinddese());
							convenios=new HashMap();//NOPMD
							if (c.get(res.getTipoconvenio())!=null){
								Map t=(Map)c.get(res.getTipoconvenio());
								if (t.get(res.getTerritorio())!=null){
									nd=Integer.parseInt((String)t.get(res.getTerritorio()))+Integer.parseInt(res.getNumdelegados());
									t.put(res.getTerritorio(), String.valueOf(nd));
									c.put(res.getTipoconvenio(),t);
									sindicatos.put(res.getSiglas()+"|"+res.getSinddesc()+"|"+res.getSinddese(), c);
								}
								else{
									t.put(res.getTerritorio(), res.getNumdelegados());
									c.put(res.getTipoconvenio(),t);
									sindicatos.put(res.getSiglas()+"|"+res.getSinddesc()+"|"+res.getSinddese(), c);
								}
							}
							else{
								territorios=new HashMap();//NOPMD
								territorios.put(res.getTerritorio(), res.getNumdelegados());
								c.put(res.getTipoconvenio(),territorios);
								sindicatos.put(res.getSiglas()+"|"+res.getSinddesc()+"|"+res.getSinddese(), c);
							}
						}
					}
				}
				if (!nacta.equals(res.getNacta())||!territ.equals(res.getTerritorio())||!anoacta.equals(res.getAnoacta())){
					maxversion=Integer.parseInt(res.getVer());
				}
				nacta=res.getNacta();
				territ=res.getTerritorio();
				anoacta=res.getAnoacta();
		    }
		}
		mapa.put("sindicatos",sindicatos);
		mapa.put("delegadosmenorigual49", String.valueOf(delegadosmenorigual49));
		mapa.put("delegadosmayor49", String.valueOf(delegadosmayor49));
		return mapa;		
	}
	
	public List obtenerNumEmpresasYCentros(w83a.w83aBeans.W83aResultadosBean param) throws Exception{
		StringBuffer strSql = new StringBuffer();//NOPMD
		List params = new ArrayList();
		strSql.append("SELECT "); 
		strSql.append(W83aResultadosBD.numcentros);
		strSql.append(" FROM TABLE (w83b.");
	    strSql.append(W83aResultadosBD.w83anumempresasycentros);
	    strSql.append("(?,?,?,?,?,?,?))");
	    
	    params.add(W83aDateUtil.getInstance().getLocaleStringFromDate(W83aDateUtil.getInstance().stringToDateIdioma(param.getFechaEleccionDesde(),param.getIdioma()), W83aClsConstantes.CONSTANTE_CASTELLANO));
	    params.add(W83aDateUtil.getInstance().getLocaleStringFromDate(W83aDateUtil.getInstance().stringToDateIdioma(param.getFechaEleccionHasta(),param.getIdioma()), W83aClsConstantes.CONSTANTE_CASTELLANO));
	    params.add(W83aDateUtil.getInstance().getLocaleStringFromDate(W83aDateUtil.getInstance().stringToDateIdioma(param.getFechaRegistroDefinitivo(),param.getIdioma()), W83aClsConstantes.CONSTANTE_CASTELLANO));
	    if(!"0".equals(param.getTerritorio())){
	    	params.add(param.getTerritorio());
	    }
	    else{
	    	params.add("todos");
	    }
	    if(StringUtils.isNotEmpty(param.getNumTrabajadores())){
	    	params.add(param.getNumTrabajadores());
	    }
	    else{
	    	params.add("todos");
	    }
	    params.add(W83aDateUtil.getInstance().getLocaleStringFromDate(W83aDateUtil.getInstance().stringToDateIdioma(param.getFeHist(),param.getIdioma()), W83aClsConstantes.CONSTANTE_CASTELLANO));
	    params.add(W83aDateUtil.getInstance().getLocaleStringFromDate(W83aDateUtil.getInstance().stringToDateIdioma(param.getFechaHistorico(),param.getIdioma()), W83aClsConstantes.CONSTANTE_CASTELLANO));
	    
		HashMap mapaQuerie = new HashMap();
		mapaQuerie.put("idioma", param.getIdioma());
		mapaQuerie.put("querie", "numempresasycentros");
	    
		return W83aDataBase.executeQuery(strSql.toString(),params,W83aResultadosBean.class,param.getUsuarioBean(), mapaQuerie);	
		
	}
	
	public java.util.List buscarDelegadosConvenio(w83a.w83aBeans.W83aResultadosBean param,boolean contar) throws Exception{
		StringBuffer strSql = new StringBuffer();//NOPMD
		List params = new ArrayList();
		if(!contar & !(param.getMin().equals(param.getMax()))){
			strSql.append("SELECT "); 
//			strSql.append(" VER,");
//07/03/2016 Se deja de buscar y agrupar sector
//			strSql.append(W83aResultadosBD.sector).append(", ");
//			strSql.append(W83aResultadosBD.descsector).append(", ");
			strSql.append(W83aResultadosBD.ncentro).append(", ");
			strSql.append(W83aResultadosBD.cif).append(", ");
			strSql.append(W83aResultadosBD.nacta).append(", ");
			strSql.append(W83aResultadosBD.anoacta).append(", ");
			strSql.append(W83aResultadosBD.territ).append(", ");
			strSql.append(W83aResultadosBD.ver).append(", ");
			strSql.append(W83aResultadosBD.totalelectores).append(", ");
			strSql.append(W83aResultadosBD.codsindicato).append(", ");
			strSql.append(W83aResultadosBD.siglas).append(", ");
			strSql.append(W83aResultadosBD.codconvenio).append(", ");
			strSql.append(W83aResultadosBD.convdesc).append(", ");
			strSql.append(W83aResultadosBD.convdese).append(", ");
			strSql.append(W83aResultadosBD.felec).append(" , ");
			strSql.append(W83aResultadosBD.fecharegistro).append(" , ");
			strSql.append(W83aResultadosBD.totalvotos).append(", ");
			strSql.append(W83aResultadosBD.numdelegados).append(", rn");
			strSql.append(" from(");
				
		}
		strSql.append("SELECT "); 
		if(contar){
			strSql.append(" count(");
			strSql.append(W83aResultadosBD.nacta).append(")");
		}else{
//			strSql.append(" VER,");
//			07/03/2016 Se deja de buscar y agrupar sector
//			strSql.append(W83aResultadosBD.sector).append(", ");
//			strSql.append(W83aResultadosBD.descsector).append(", ");
			strSql.append(W83aResultadosBD.ncentro).append(", ");
			strSql.append(W83aResultadosBD.cif).append(", ");
			strSql.append(W83aResultadosBD.nacta).append(", ");
			strSql.append(W83aResultadosBD.anoacta).append(", ");
			strSql.append(W83aResultadosBD.territ).append(", ");
			strSql.append(W83aResultadosBD.ver).append(", ");
			strSql.append(W83aResultadosBD.totalelectores).append(", ");
			strSql.append(W83aResultadosBD.codsindicato).append(", ");
			strSql.append(W83aResultadosBD.siglas).append(", ");
			strSql.append(W83aResultadosBD.codconvenio).append(", ");
			strSql.append(W83aResultadosBD.convdesc).append(", ");
			strSql.append(W83aResultadosBD.convdese).append(", ");
			strSql.append("TO_CHAR(").append(W83aResultadosBD.felec).append(",?) AS ").append(W83aResultadosBD.felec).append(" , ");
			strSql.append("TO_CHAR(").append(W83aResultadosBD.fecharegistro).append(",?) AS ").append(W83aResultadosBD.fecharegistro).append(" , ");
			strSql.append(W83aResultadosBD.totalvotos).append(", ");
			strSql.append(W83aResultadosBD.numdelegados).append(" , ");
			strSql.append("  row_number() over ( ");
			strSql.append(" ORDER BY ");
//			07/03/2016 Se deja de buscar y agrupar sector
			//strSql.append(W83aResultadosBD.sector).append(" asc, ");
			strSql.append(W83aResultadosBD.convdesc).append(" asc, ");
			strSql.append(W83aResultadosBD.codsindicato).append(" asc, ");
			strSql.append(W83aResultadosBD.nacta).append(",");
			strSql.append(W83aResultadosBD.territ).append(" ,");
			strSql.append(W83aResultadosBD.anoacta).append(" ,");
			strSql.append(W83aResultadosBD.ver).append(" ");
			strSql.append(") as rn");
			params.add(W83aDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
			params.add(W83aDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		}
		strSql.append(" FROM w83b.W83BDELEGADOSPORCONVENIOHIST DC, ");
		strSql.append("(SELECT   MAX (").append(W83aResultadosBD.VERSION_016).append(") AS MAXVER, ");
		strSql.append(W83aResultadosBD.N_ACTA_016).append(",").append(W83aResultadosBD.ANO_ACTA_016).append(",");
		strSql.append(W83aResultadosBD.C_TERRIT_016).append(" FROM ").append(W83aResultadosBD.tabla16).append(" WHERE ");
			
			//QUITADO POR JAVI
			//SE SUPONE EL SGTE CASO:
			//UN ACTA V0 CON FECHA DE ELECCIN DE 30/5/2012
			//SE CREA UNA INICIDENCIA Y SE CAMBIA EL 27/06/2013 (FACTU) LA FECHA DE ELECCIN A 01/06/2013
			//SACAMOS ESTE INFORME CON FECHA HISTORICO 27/05/2013 PARA QUE LA INCIDENCIA CUENTE, 
			//Y EN FECHA DE RESULTADO PONEMOS 31/05/2013
			//AL SER LA FECHA DE ELECCIN ENTRE 01/06/2009 - 31/05/2013
			//Y LA VERSIN QUE CUENTA PARA ESA FECHA HISTRICO ES LA VERSIN DE LA INCIDENCIA
			//ESTE ACTA NO DEBERA SALIR. 
			//AL COGER LA QUERY QUE COGE LA MAXVERSION EL ACTA QUE COINCIDE CON  FECHA DE ELECCIN ENTRE 01/06/2009 - 31/05/2013
			//CONSIDERA SOLO LA VERSIN 0
			//HE KITADO ESAS LNEAS XQ ESE FILTRO LO DEBERA HACER LA OTRA QUERY
			/*if(StringUtils.isNotEmpty(param.getFechaRegistroDefinitivo())){
				strSql.append(W83bResultadosBD.FREGDEF_016).append("<=").append("TO_DATE(?,'dd/MM/yyyy') ");
				params.add(W83bDateUtil.getInstance().getLocaleStringFromDate(W83bDateUtil.getInstance().stringToDateIdioma(param.getFechaRegistroDefinitivo(),param.getIdioma()), W83bClsConstantes.CONSTANTE_CASTELLANO));
			}
			if(StringUtils.isNotEmpty(param.getFechaEleccionDesde())){
				strSql.append(" AND ");
				strSql.append(W83bResultadosBD.F_ELECC_016).append(">=").append("TO_DATE(?,'dd/MM/yyyy') ");
				params.add(W83bDateUtil.getInstance().getLocaleStringFromDate(W83bDateUtil.getInstance().stringToDateIdioma(param.getFechaEleccionDesde(),param.getIdioma()), W83bClsConstantes.CONSTANTE_CASTELLANO));
			}
			if(StringUtils.isNotEmpty(param.getFechaEleccionHasta())){
				strSql.append(" AND ");
				strSql.append(W83bResultadosBD.F_ELECC_016).append("<=").append("TO_DATE(?,'dd/MM/yyyy') ");
				params.add(W83bDateUtil.getInstance().getLocaleStringFromDate(W83bDateUtil.getInstance().stringToDateIdioma(param.getFechaEleccionHasta(),param.getIdioma()), W83bClsConstantes.CONSTANTE_CASTELLANO));
			}*/
		if(!"0".equals(param.getTerritorio())){
			//strSql.append(" AND ");
			strSql.append(W83aResultadosBD.C_TERRIT_016).append("=").append("? ");
			params.add(param.getTerritorio());
			strSql.append(" AND ");				
		}
		strSql.append("  (").append(W83aResultadosBD.factu_016).append("<=TO_DATE('").append(W83aDateUtil.getInstance().getLocaleStringFromDate(W83aDateUtil.getInstance().stringToDateIdioma(param.getFeHist(),param.getIdioma()), W83aClsConstantes.CONSTANTE_CASTELLANO)).append(" 23:59:59','dd/MM/yyyy hh24:mi:ss') OR ");
		strSql.append(W83aResultadosBD.factu_016).append(" IS NULL )");
		strSql.append(" AND ").append(W83aResultadosBD.validada_016).append("=1");
		strSql.append("GROUP BY ").append(W83aResultadosBD.N_ACTA_016).append(",");
		strSql.append(W83aResultadosBD.ANO_ACTA_016).append(",").append(W83aResultadosBD.C_TERRIT_016).append(") MAXRESULTS");
			
		strSql.append(" WHERE ");
			
		strSql.append(" DC.NACTA = MAXRESULTS.").append(W83aResultadosBD.N_ACTA_016 );
		strSql.append(" AND DC.ANOACTA = MAXRESULTS.").append(W83aResultadosBD.ANO_ACTA_016 );
		strSql.append(" AND DC.TERRIT = MAXRESULTS.").append(W83aResultadosBD.C_TERRIT_016 );
		if(StringUtils.isNotEmpty(param.getFechaRegistroDefinitivo())){
			strSql.append(" AND ");
			strSql.append("DC.FECHAREGISTRO").append("<=").append("TO_DATE(?,'dd/MM/yyyy') ");
			params.add(W83aDateUtil.getInstance().getLocaleStringFromDate(W83aDateUtil.getInstance().stringToDateIdioma(param.getFechaRegistroDefinitivo(),param.getIdioma()), W83aClsConstantes.CONSTANTE_CASTELLANO));
		}
		if(StringUtils.isNotEmpty(param.getFechaEleccionDesde())){
			strSql.append(" AND ");
			strSql.append("DC.FELEC").append(">=").append("TO_DATE(?,'dd/MM/yyyy') ");
			params.add(W83aDateUtil.getInstance().getLocaleStringFromDate(W83aDateUtil.getInstance().stringToDateIdioma(param.getFechaEleccionDesde(),param.getIdioma()), W83aClsConstantes.CONSTANTE_CASTELLANO));
		}
		if(StringUtils.isNotEmpty(param.getFechaEleccionHasta())){
			strSql.append(" AND ");
			strSql.append("DC.FELEC").append("<=").append("TO_DATE(?,'dd/MM/yyyy') ");
			params.add(W83aDateUtil.getInstance().getLocaleStringFromDate(W83aDateUtil.getInstance().stringToDateIdioma(param.getFechaEleccionHasta(),param.getIdioma()), W83aClsConstantes.CONSTANTE_CASTELLANO));
		}
		if(!"0".equals(param.getTerritorio())){
			strSql.append(" AND ");
			strSql.append("DC.TERRIT").append("=").append("? ");
			params.add(param.getTerritorio());
		}
//		07/03/2016 Se deja de buscar y agrupar sector
/*		if(StringUtils.isNotEmpty(param.getSector())){
			strSql.append(" AND ");
			strSql.append(W83aResultadosBD.sector).append("=").append("? ");
			params.add(param.getSector());
		}
*/
		if(StringUtils.isNotEmpty(param.getConvenio())){
			strSql.append(" AND ");
			strSql.append(W83aResultadosBD.codconvenio).append("=").append("? ");
			params.add(param.getConvenio());
		}
		strSql.append(" AND ");
		strSql.append("DC.VER").append("=").append("MAXRESULTS.MAXVER ");
		//Aadido por Eva, lo de la fecha de baja
		//if(StringUtils.isNotEmpty(param.getFechaEleccionHasta())){
			strSql.append(" AND ("); 
			strSql.append(W83aResultadosBD.fechabaja).append(" IS NULL");
			strSql.append(" OR ("); 
			strSql.append(W83aResultadosBD.fechabaja).append(" IS NOT NULL");
			strSql.append(" AND ");  
			strSql.append(W83aResultadosBD.fechabaja).append(" > ").append("TO_DATE(?, 'dd/MM/yyyy')");
			params.add(W83aDateUtil.getInstance().getLocaleStringFromDate(W83aDateUtil.getInstance().stringToDateIdioma(param.getFechaHistorico(),param.getIdioma()), W83aClsConstantes.CONSTANTE_CASTELLANO));
			strSql.append(" )) ");  
		//}
		if(!contar & !(param.getMin().equals(param.getMax()))){
				strSql.append(") where (rn>? AND rn<=?)");
				params.add(param.getMin());
				params.add(param.getMax());				
		}	
				
		strSql.append(" ORDER BY ");
//		07/03/2016 Se deja de buscar y agrupar sector
//		strSql.append(W83aResultadosBD.sector).append(" asc, ");
		strSql.append(W83aResultadosBD.convdesc).append(" asc, ");
		strSql.append(W83aResultadosBD.codsindicato).append(" asc, ");
		strSql.append(W83aResultadosBD.nacta).append(",");
		strSql.append(W83aResultadosBD.territ).append(" ,");
		strSql.append(W83aResultadosBD.anoacta).append(" ,");
		strSql.append(W83aResultadosBD.ver).append(" ");

		HashMap mapa = new HashMap();
		mapa.put("idioma", param.getIdioma());
		mapa.put("querie", "delegadosPorConvenio");
			
		if(contar){
			return W83aDataBase.executeSimpleQuery(strSql.toString(),params,param.getUsuarioBean());			
		}else{
			return W83aDataBase.executeQuery(strSql.toString(),params,W83aResultadosBean.class,param.getUsuarioBean(),mapa );			
		}
	}
	
	public java.util.List buscarDelegConvDetCentro(w83a.w83aBeans.W83aResultadosBean param,boolean contar) throws Exception{
		StringBuffer strSql = new StringBuffer();//NOPMD
		List params = new ArrayList();
		if(!contar & !(param.getMin().equals(param.getMax()))){
			strSql.append("SELECT ");
//			07/03/2016 Se deja de buscar y agrupar sector			
//			strSql.append(W83aResultadosBD.sector).append(", ");
//			strSql.append(W83aResultadosBD.descsector).append(", ");
			strSql.append(W83aResultadosBD.ncentro).append(", ");
			strSql.append(W83aResultadosBD.cif).append(", ").append(W83aResultadosBD.razon).append(", ").append(W83aResultadosBD.nacta).append(", ");
			strSql.append(W83aResultadosBD.anoacta).append(", ").append(W83aResultadosBD.territ).append(", ").append(W83aResultadosBD.ver).append(", ");
			strSql.append(W83aResultadosBD.totalelectores).append(", ").append(W83aResultadosBD.codsindicato).append(", ");
			strSql.append(W83aResultadosBD.siglas).append(", ").append(W83aResultadosBD.codconvenio).append(", ");
			strSql.append(W83aResultadosBD.convdesc).append(", ").append(W83aResultadosBD.convdese).append(", ");
			strSql.append(W83aResultadosBD.felec).append(" , ");
			strSql.append(W83aResultadosBD.fecharegistro).append(" , ");
			strSql.append(W83aResultadosBD.totalvotos).append(", ");
			strSql.append(W83aResultadosBD.numdelegados).append(", ");
			strSql.append(W83aResultadosBD.nactacompleta).append(", rn");
			strSql.append(" from ( ");
			
		}
		strSql.append("SELECT "); 
		if(contar){
			strSql.append(" count(");
			strSql.append(W83aResultadosBD.nacta).append(")");
		}else{
//			07/03/2016 Se deja de buscar y agrupar sector			
//			strSql.append(W83aResultadosBD.sector).append(", ");
//			strSql.append(W83aResultadosBD.descsector).append(", ");
			strSql.append(W83aResultadosBD.ncentro).append(", ");
			strSql.append(W83aResultadosBD.cif).append(", ").append(W83aResultadosBD.razon).append(", ").append(W83aResultadosBD.nacta).append(", ");
			strSql.append(W83aResultadosBD.anoacta).append(", ").append(W83aResultadosBD.territ).append(", ").append(W83aResultadosBD.ver).append(", ");
			strSql.append(W83aResultadosBD.totalelectores).append(", ").append(W83aResultadosBD.codsindicato).append(", ");
			strSql.append(W83aResultadosBD.siglas).append(", ").append(W83aResultadosBD.codconvenio).append(", ");
			strSql.append(W83aResultadosBD.convdesc).append(", ").append(W83aResultadosBD.convdese).append(", ");
			strSql.append("TO_CHAR(").append(W83aResultadosBD.felec).append(",?) AS ").append(W83aResultadosBD.felec).append(" , ");
			strSql.append("TO_CHAR(").append(W83aResultadosBD.fecharegistro).append(",?) AS ").append(W83aResultadosBD.fecharegistro).append(" , ");
			strSql.append(W83aResultadosBD.totalvotos).append(", ");
			strSql.append(W83aResultadosBD.numdelegados).append(", ");
			strSql.append(W83aResultadosBD.nactacompleta).append(", ");
			strSql.append("  row_number() over ( ");
			strSql.append(" ORDER BY ");
			strSql.append(W83aResultadosBD.codconvenio);
			strSql.append(", ");
			strSql.append(W83aResultadosBD.razon);
			strSql.append(", ");
			strSql.append(W83aResultadosBD.nacta);
			strSql.append(", ");
			strSql.append(W83aResultadosBD.territ);
			strSql.append(", ");
			strSql.append(W83aResultadosBD.anoacta);
			strSql.append(", ");
			strSql.append(W83aResultadosBD.ver);
			strSql.append(", ");
			strSql.append(W83aResultadosBD.codsindicato);
			strSql.append(") as rn");
			params.add(W83aDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
			params.add(W83aDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		}

		strSql.append(" FROM w83b.").append(W83aResultadosBD.w83adelegporconvdetcenhist);
		strSql.append(" WHERE ");
		if(StringUtils.isNotEmpty(param.getFechaRegistroDefinitivo())){
			strSql.append(W83aResultadosBD.fecharegistro).append("<=").append("TO_DATE(?,'dd/MM/yyyy') ");
			params.add(W83aDateUtil.getInstance().getLocaleStringFromDate(W83aDateUtil.getInstance().stringToDateIdioma(param.getFechaRegistroDefinitivo(),param.getIdioma()), W83aClsConstantes.CONSTANTE_CASTELLANO));
		}
		if(StringUtils.isNotEmpty(param.getFechaEleccionHasta())){
			strSql.append(" AND ");
			strSql.append(W83aResultadosBD.felec).append("<=").append("TO_DATE(?,'dd/MM/yyyy') ");
			params.add(W83aDateUtil.getInstance().getLocaleStringFromDate(W83aDateUtil.getInstance().stringToDateIdioma(param.getFechaEleccionHasta(),param.getIdioma()), W83aClsConstantes.CONSTANTE_CASTELLANO));
		}
		if(StringUtils.isNotEmpty(param.getFechaEleccionDesde())){
			strSql.append(" AND ");
			strSql.append(W83aResultadosBD.felec).append(">=").append("TO_DATE(?,'dd/MM/yyyy') ");
			params.add(W83aDateUtil.getInstance().getLocaleStringFromDate(W83aDateUtil.getInstance().stringToDateIdioma(param.getFechaEleccionDesde(),param.getIdioma()), W83aClsConstantes.CONSTANTE_CASTELLANO));
		}
//		07/03/2016 Se deja de buscar y agrupar sector
/*		if(StringUtils.isNotEmpty(param.getSector())){
			strSql.append(" AND ");
			strSql.append(W83aResultadosBD.sector).append("=").append("? ");
			params.add(param.getSector());
		}
*/
		if(!"0".equals(param.getTerritorio())){
			strSql.append(" AND ");
			strSql.append(W83aResultadosBD.territ).append("=").append("? ");
			params.add(param.getTerritorio());
		}		
		if(StringUtils.isNotEmpty(param.getConvenio())){
			strSql.append(" AND ");
			strSql.append(W83aResultadosBD.codconvenio).append("=").append("? ");
			params.add(param.getConvenio());
		}
		//Aadido por Eva, lo de la fecha de baja
//		if(StringUtils.isNotEmpty(param.getFechaEleccionHasta())){
			strSql.append(" AND ("); 
			strSql.append(W83aResultadosBD.fechabaja).append(" IS NULL");
			strSql.append(" OR ("); 
			strSql.append(W83aResultadosBD.fechabaja).append(" IS NOT NULL");
			strSql.append(" AND ");  
			strSql.append(W83aResultadosBD.fechabaja).append(" > ").append("TO_DATE(?, 'dd/MM/yyyy')");
			params.add(W83aDateUtil.getInstance().getLocaleStringFromDate(W83aDateUtil.getInstance().stringToDateIdioma(param.getFechaHistorico(),param.getIdioma()), W83aClsConstantes.CONSTANTE_CASTELLANO));
			strSql.append(" )) ");  
//		}
				
//			strSql.append(" AND (");
//			strSql.append(W83bResultadosBD.fechaActu).append("<=").append("TO_DATE(?,?) OR ");
//			strSql.append(W83bResultadosBD.fechaActu).append(" IS NULL) ");
				
			strSql.append(" AND ").append(W83aResultadosBD.ver).append(" = (select max(actas.");
			strSql.append(W83aActasBD.versionActa).append(") from ").append(W83aActasBD.actasTable).append(" actas ");
			strSql.append(" where (actas.");
			strSql.append(W83aActasBD.fechaActualizacion).append("<=").append("TO_DATE(?,?) ");
			params.add(param.getFeHist());
			params.add(W83aDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
			strSql.append(" or actas.").append(W83aActasBD.fechaActualizacion).append(" is null)");
			strSql.append(" AND actas.").append(W83aActasBD.anyoActa).append("= ").append(W83aResultadosBD.anoacta);
			strSql.append(" AND actas.");
			strSql.append(W83aActasBD.numActa).append("= ").append(W83aResultadosBD.nacta);
			strSql.append(" AND actas.");
			strSql.append(W83aActasBD.codTerritActa).append(" = ").append(W83aResultadosBD.territ);
			strSql.append(" AND actas.");
			strSql.append(W83aActasBD.validada).append("= ? )");
			params.add(W83aClsConstantes.CONSTANTE_VALIDADA);							

		if(!contar & !(param.getMin().equals(param.getMax()))){
			strSql.append(") where (rn>? AND rn<=?)");
			params.add(param.getMin());
			params.add(param.getMax());				
		}
//		strSql.append(" ORDER BY ");
//		strSql.append(W83bResultadosBD.codconvenio);
//		strSql.append(", ");
//		strSql.append(W83bResultadosBD.razon);
//		strSql.append(", ");
//		strSql.append(W83bResultadosBD.nacta);
//		strSql.append(", ");
//		strSql.append(W83bResultadosBD.territ);
//		strSql.append(", ");
//		strSql.append(W83bResultadosBD.anoacta);
//		strSql.append(", ");
//		strSql.append(W83bResultadosBD.ver);
//		strSql.append(", ");
//		strSql.append(W83bResultadosBD.codsindicato);
		
		
		HashMap mapa = new HashMap();
		mapa.put("idioma", param.getIdioma());
		mapa.put("querie", "delegadosConvenioDetCentro");
		
		if(contar){
			return W83aDataBase.executeSimpleQuery(strSql.toString(),params,param.getUsuarioBean());			
		}else{
			return W83aDataBase.executeQuery(strSql.toString(),params,W83aResultadosBean.class,param.getUsuarioBean(), mapa);
		}
	}
	
	public java.util.List buscarResCentroSindicato(w83a.w83aBeans.W83aResultadosBean param,boolean contar) throws Exception{
		StringBuffer strSql = new StringBuffer(W83aClsConstantes.CUARENTA);
		List params = new ArrayList();
		strSql = new StringBuffer(W83aClsConstantes.CUARENTA);
		if(!contar & !(param.getMin().equals(param.getMax()))){
			strSql.append("SELECT "); 
			strSql.append(W83aResultadosBD.nacta).append(", ");
			strSql.append(W83aResultadosBD.territ).append(", ");
			strSql.append(W83aResultadosBD.anoacta).append(", ");
			strSql.append(W83aResultadosBD.ver).append(", ");
			strSql.append(W83aResultadosBD.anoregdef).append(", ");
			strSql.append(W83aResultadosBD.nregdef).append(", ");
			strSql.append(W83aResultadosBD.felec).append(" , ");
			strSql.append(W83aResultadosBD.cif).append(", ");
			strSql.append(W83aResultadosBD.sector).append(", ");
			strSql.append(W83aResultadosBD.razon).append(", ");
			strSql.append(W83aResultadosBD.ncentro).append(", ");
			strSql.append(W83aResultadosBD.convdesc).append(", ");
			strSql.append(W83aResultadosBD.totalelectores).append(", ");
			strSql.append(W83aResultadosBD.numdelegados).append(" , ");
			strSql.append(W83aResultadosBD.sinddesc).append(", ");
			strSql.append(W83aResultadosBD.siglas).append(", ");
			strSql.append(W83aResultadosBD.codsindicato).append(", rn");
			strSql.append(" from(");
				
		}
		strSql.append("SELECT "); 
		if(contar){
			strSql.append(" count(");
			strSql.append(W83aResultadosBD.nacta).append(")");
		}else{
				strSql.append(W83aResultadosBD.nacta).append(", ");
				strSql.append(W83aResultadosBD.territ).append(", ");
				strSql.append(W83aResultadosBD.anoacta).append(", ");
				strSql.append(W83aResultadosBD.ver).append(", ");
				strSql.append(W83aResultadosBD.anoregdef).append(", ");
				strSql.append(W83aResultadosBD.nregdef).append(", ");
				strSql.append("TO_CHAR(").append(W83aResultadosBD.felec).append(",?) AS ").append(W83aResultadosBD.felec).append(" , ");
				strSql.append(W83aResultadosBD.cif).append(", ");
				strSql.append(W83aResultadosBD.sector).append(", ");
				strSql.append(W83aResultadosBD.razon).append(", ");
				strSql.append(W83aResultadosBD.ncentro).append(", ");
				strSql.append(W83aResultadosBD.convdesc).append(", ");
				strSql.append(W83aResultadosBD.totalelectores).append(", ");
				strSql.append("SUM(").append(W83aResultadosBD.numdelegados).append(") AS ").append(W83aResultadosBD.numdelegados).append(" , ");
				strSql.append(W83aResultadosBD.sinddesc).append(", ");
				strSql.append(W83aResultadosBD.siglas).append(", ");
				strSql.append(W83aResultadosBD.codsindicato).append(", ");
				strSql.append("  row_number() over ( ");
				strSql.append(" ORDER BY ");
				strSql.append(W83aResultadosBD.nactacompleta);
				strSql.append(") as rn");
				params.add(W83aDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
			}
			strSql.append(" FROM W83B.").append(W83aResultadosBD.vistaResCenSindHist);
			strSql.append(" WHERE ");
			//SOLO PARA PROBAR DE QUE SALE COMO EL RESTO DE LOS INFORMES
//			strSql.append(" fecharegistro<=TO_DATE('01/03/1998','dd/MM/yyyy') and ");
			if(StringUtils.isNotEmpty(param.getTerritorio())){
				strSql.append(W83aResultadosBD.territ).append("=").append("? ");
				params.add(param.getTerritorio());
//				strSql.append(W83bResultadosBD.territ).append(" in").append("(01,48,20) ");
			}
			if(StringUtils.isNotEmpty(param.getNumRegDefDesde())){
				strSql.append(" AND ((");
				strSql.append(W83aResultadosBD.anoregdef).append("=").append("? ");
				strSql.append(" AND ");
				strSql.append(W83aResultadosBD.nregdef).append(">=").append("? ");
				strSql.append(") OR (");
				strSql.append(W83aResultadosBD.anoregdef).append(">").append("? ");
				strSql.append(" AND ");
				strSql.append(W83aResultadosBD.nregdef).append(">=0))");
				params.add(param.getAnoRegDefDesde());
				params.add(param.getNumRegDefDesde());
				params.add(param.getAnoRegDefDesde());
			}
			else{
				if(StringUtils.isNotEmpty(param.getAnoRegDefDesde())){
					strSql.append(" AND ");
					strSql.append(W83aResultadosBD.anoregdef).append(">=").append("? ");
					params.add(param.getAnoRegDefDesde());
			}
			}
			if(StringUtils.isNotEmpty(param.getNumRegDefHasta())){
				strSql.append(" AND ((");
				strSql.append(W83aResultadosBD.anoregdef).append("=").append("? ");
				strSql.append(" AND ");
				strSql.append(W83aResultadosBD.nregdef).append("<=").append("? ");
				strSql.append(") OR (");
				strSql.append(W83aResultadosBD.anoregdef).append("<").append("? ");
				strSql.append(" AND ");
				strSql.append(W83aResultadosBD.nregdef).append(">=0))");
				params.add(param.getAnoRegDefHasta());
				params.add(param.getNumRegDefHasta());
				params.add(param.getAnoRegDefHasta());
			}
			else{
				if(StringUtils.isNotEmpty(param.getAnoRegDefHasta())){
					strSql.append(" AND ");
					strSql.append(W83aResultadosBD.anoregdef).append("<=").append("? ");
					params.add(param.getAnoRegDefHasta());
				}
			}
			if(StringUtils.isNotEmpty(param.getNumActaDesde())){
				strSql.append(" AND ((");
				strSql.append(W83aResultadosBD.anoacta).append("=").append("? ");
				strSql.append(" AND ");
				strSql.append(W83aResultadosBD.nacta).append(">=").append("? ");
				strSql.append(") OR (");
				strSql.append(W83aResultadosBD.anoacta).append(">").append("? ");
				strSql.append(" AND ");
				strSql.append(W83aResultadosBD.nacta).append(">=0))");
				params.add(param.getAnoActaDesde());
				params.add(param.getNumActaDesde());
				params.add(param.getAnoActaDesde());
			}
			else{
				if(StringUtils.isNotEmpty(param.getAnoActaDesde())){
					strSql.append(" AND ");
					strSql.append(W83aResultadosBD.anoacta).append(">=").append("? ");
					params.add(param.getAnoActaDesde());
				}
			}
			
			if(StringUtils.isNotEmpty(param.getNumActaHasta())){
					strSql.append(" AND ((");
					strSql.append(W83aResultadosBD.anoacta).append("=").append("? ");
					strSql.append(" AND ");
					strSql.append(W83aResultadosBD.nacta).append("<=").append("? ");
					strSql.append(") OR (");
					strSql.append(W83aResultadosBD.anoacta).append("<").append("? ");
					strSql.append(" AND ");
					strSql.append(W83aResultadosBD.nacta).append(">=0))");
					params.add(param.getAnoActaHasta());
					params.add(param.getNumActaHasta());
					params.add(param.getAnoActaHasta());
				}
			else{
				if(StringUtils.isNotEmpty(param.getAnoActaHasta())){
					strSql.append(" AND ");
					strSql.append(W83aResultadosBD.anoacta).append("<=").append("? ");
					params.add(param.getAnoActaHasta());
				}
				}
			if(StringUtils.isNotEmpty(param.getFechaEleccionDesde())){
				strSql.append(" AND ");
				strSql.append(W83aResultadosBD.felec).append(">=").append("TO_DATE(?,'dd/MM/yyyy') ");
				params.add(W83aDateUtil.getInstance().getLocaleStringFromDate(W83aDateUtil.getInstance().stringToDateIdioma(param.getFechaEleccionDesde(),param.getIdioma()), W83aClsConstantes.CONSTANTE_CASTELLANO));
			}
			if(StringUtils.isNotEmpty(param.getFechaEleccionHasta())){
				strSql.append(" AND ");
				strSql.append(W83aResultadosBD.felec).append("<=").append("TO_DATE(?,'dd/MM/yyyy') ");
				params.add(W83aDateUtil.getInstance().getLocaleStringFromDate(W83aDateUtil.getInstance().stringToDateIdioma(param.getFechaEleccionHasta(),param.getIdioma()), W83aClsConstantes.CONSTANTE_CASTELLANO));
			}

			//Aadido por Eva, lo de la fecha de baja
			//if(StringUtils.isNotEmpty(param.getFelecHasta())){
				strSql.append(" AND ("); 
				strSql.append(W83aResultadosBD.fechabaja).append(" IS NULL");
				strSql.append(" OR ("); 
				strSql.append(W83aResultadosBD.fechabaja).append(" IS NOT NULL");
				strSql.append(" AND ");  
				strSql.append(W83aResultadosBD.fechabaja).append(" > ").append("TO_DATE(?, 'dd/MM/yyyy')");
				params.add(W83aDateUtil.getInstance().getLocaleStringFromDate(W83aDateUtil.getInstance().stringToDateIdioma(param.getFechaHistorico(),param.getIdioma()), W83aClsConstantes.CONSTANTE_CASTELLANO));
				strSql.append(" )) ");  
			//}
			
			strSql.append(" AND ver =(SELECT MAX (VERSION_016) FROM ").append(W83aActasBD.actasTable).append(" ACT WHERE (");
			strSql.append(W83aActasBD.fechaActualizacion).append("<=").append("TO_DATE(?,'dd/MM/yyyy') OR ");
			strSql.append(W83aActasBD.fechaActualizacion).append(" IS NULL )");
			
			params=this.aniadirFechaHistorico(params,param);
			strSql.append(" AND ACT.").append(W83aActasBD.anyoActa).append("=anoacta AND ACT.");
			strSql.append(W83aActasBD.numActa).append("=nacta AND ACT.");
			strSql.append(W83aActasBD.codTerritActa).append("=territ ");
			strSql.append(" AND ACT.").append(W83aResultadosBD.validada_016).append("=1)");
			

			if(!contar){			
				strSql.append(" GROUP BY ");
				
				strSql.append(W83aResultadosBD.nactacompleta).append(", ").append(W83aResultadosBD.nacta).append(", ").append(W83aResultadosBD.territ).append(", ").append(W83aResultadosBD.anoacta)
				.append(", ").append(W83aResultadosBD.ver).append(", ").append(W83aResultadosBD.anoregdef).append(", ").append(W83aResultadosBD.nregdef).append(", ").append(W83aResultadosBD.felec)
				.append(", ").append(W83aResultadosBD.cif).append(", ").append(W83aResultadosBD.sector).append(", ").append(W83aResultadosBD.razon).append(", ").append(W83aResultadosBD.ncentro)
				.append(", ").append(W83aResultadosBD.convdesc).append(", ").append(W83aResultadosBD.totalelectores).append(", ").append(W83aResultadosBD.sinddesc).append(", ").append(W83aResultadosBD.siglas)
				.append(", ").append(W83aResultadosBD.codsindicato);
				strSql.append(" ORDER BY ");
				strSql.append(W83aResultadosBD.nactacompleta);				
			}
			
			if(!contar & !(param.getMin().equals(param.getMax()))){
				strSql.append(") where (rn>? AND rn<=?)");
				params.add(param.getMin());
				params.add(param.getMax());				
			}
			
//			strSql.append(" ORDER BY ");
//			strSql.append(W83bResultadosBD.nacta).append(" asc, ");
//			strSql.append(W83bResultadosBD.anoacta).append(" asc, ");
//			strSql.append(W83bResultadosBD.territ).append(" asc, ");
//			strSql.append(W83bResultadosBD.codsindicato).append(" asc");
						
		HashMap mapa = new HashMap();
		mapa.put("idioma", param.getIdioma());
		mapa.put("querie", "resCentroSindicato");
		if(contar){
			return W83aDataBase.executeSimpleQuery(strSql.toString(),params,param.getUsuarioBean());			
		}else{
			return W83aDataBase.executeQuery(strSql.toString(),params,param.getUsuarioBean());
		}
//		return W83bDataBase.executeQuery(strSql.toString(),params,W83bResultadosBean.class,param.getUsuarioBean(), mapa);
	}
	
	/**
	 * Aniadir fecha historico.
	 *
	 * @param paramsp the paramsp
	 * @param param the param
	 * @return the list
	 * @throws ParseException the parse exception
	 * @throws Exception the exception
	 */
	private List aniadirFechaHistorico(List paramsp, w83a.w83aBeans.W83aResultadosBean param) throws ParseException, Exception
	{
		List params=paramsp;
		params.add(W83aDateUtil.getInstance().getLocaleStringFromDate(W83aDateUtil.getInstance().stringToDateIdioma(param.getFeHist(),param.getIdioma()), W83aClsConstantes.CONSTANTE_CASTELLANO));
		return params;
	}
	
}

